/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public final class CountUtil {
    private CountUtil() {
    }

    public static void renderCountString(FontRenderer font, long count, int xPosition, int yPosition, boolean relative) {
        CountUtil.renderCountString(font, count, xPosition, yPosition, relative, false);
    }

    public static void renderCountString(FontRenderer font, long count, int xPosition, int yPosition, boolean relative, boolean alwaysScale) {
        String countText = CountUtil.minifyCountString(count);
        CountUtil.renderStringAsCount(font, countText, xPosition, yPosition, -1, relative, alwaysScale || count > 99L);
    }

    public static void renderStringAsCount(FontRenderer font, String count, int xPosition, int yPosition, int color, boolean relative, boolean scale) {
        int x;
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        if (scale) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        }
        int n = scale ? (relative ? xPosition + 16 : xPosition) * 2 - font.func_78256_a(count) : (x = (relative ? xPosition + 17 : xPosition) - font.func_78256_a(count));
        int y = scale ? (relative ? yPosition + 16 : yPosition) * 2 - 8 : (relative ? yPosition + 9 : yPosition);
        font.func_175063_a(count, (float)x, (float)y, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }

    public static String minifyCountString(long count) {
        if (count <= 9999L) {
            return String.valueOf(count);
        }
        if (count <= 999999L) {
            float k = (float)count / 1000.0f;
            return String.format(k % 1.0f == 0.0f ? "%.0fk" : "%.1fk", Float.valueOf(k));
        }
        if (count <= 999999999L) {
            float m = (float)count / 1000000.0f;
            return String.format(m % 1.0f == 0.0f ? "%.0fm" : "%.1fm", Float.valueOf(m));
        }
        float g = (float)count / 1.0E9f;
        return String.format(g % 1.0f == 0.0f ? "%.0fg" : "%.1fg", Float.valueOf(g));
    }
}

