/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientSet;

public class ModIngredientRegistration
implements IModIngredientRegistration {
    private final Map<IIngredientType, Collection> allIngredientsMap = new Reference2ObjectOpenHashMap();
    public static final List<IIngredientType> CRAFTABLE_INGREDIENTS = new ObjectArrayList();
    private final Map<IIngredientType, IIngredientHelper> ingredientHelperMap = new Reference2ObjectOpenHashMap();
    private final Map<IIngredientType, IIngredientRenderer> ingredientRendererMap = new Reference2ObjectOpenHashMap();

    @Override
    public <V> void register(IIngredientType<V> ingredientType, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(allIngredients, "allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, "ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        this.allIngredientsMap.put(ingredientType, allIngredients);
        this.ingredientHelperMap.put(ingredientType, ingredientHelper);
        this.ingredientRendererMap.put(ingredientType, ingredientRenderer);
    }

    @Override
    public <V> void markAsCraftable(IIngredientType<V> ingredientType) {
        CRAFTABLE_INGREDIENTS.add(ingredientType);
    }

    @Override
    @Deprecated
    public <V> void register(Class<V> ingredientClass, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        this.register(() -> ingredientClass, allIngredients, ingredientHelper, ingredientRenderer);
    }

    public IngredientRegistry createIngredientRegistry(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist) {
        Reference2ObjectOpenHashMap ingredientsMap = new Reference2ObjectOpenHashMap();
        for (Map.Entry<IIngredientType, Collection> entry : this.allIngredientsMap.entrySet()) {
            IIngredientType ingredientType = entry.getKey();
            IngredientSet ingredientSet = this.createIngredientSet(ingredientType, entry.getValue());
            ingredientsMap.put(ingredientType, ingredientSet);
        }
        return new IngredientRegistry(modIdHelper, blacklist, (Map<IIngredientType, IngredientSet>)ingredientsMap, (ImmutableMap<IIngredientType, IIngredientHelper>)ImmutableMap.copyOf(this.ingredientHelperMap), (ImmutableMap<IIngredientType, IIngredientRenderer>)ImmutableMap.copyOf(this.ingredientRendererMap), (ImmutableList<IIngredientType>)ImmutableList.copyOf(CRAFTABLE_INGREDIENTS));
    }

    private <T> IngredientSet<T> createIngredientSet(IIngredientType<T> ingredientType, Collection<T> ingredients) {
        IIngredientHelper ingredientHelper = this.ingredientHelperMap.get(ingredientType);
        IngredientSet<T> ingredientSet = IngredientSet.create(ingredientType, ingredientHelper);
        ingredientSet.addAll(ingredients);
        return ingredientSet;
    }
}

