/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.BookmarkOverlayToggleEvent;
import mezz.jei.config.ConfigValues;
import mezz.jei.config.EditModeToggleEvent;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.config.OverlayToggleEvent;
import mezz.jei.config.ServerInfo;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.GiveMode;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;

public final class Config {
    private static final String configKeyPrefix = "config.jei";
    public static final String CATEGORY_SEARCH = "search";
    public static final String CATEGORY_ADVANCED = "advanced";
    public static final String CATEGORY_SEARCH_COLORS = "searchColors";
    public static final String CATEGORY_RENDERING = "rendering";
    public static final String CATEGORY_MISC = "misc";
    public static final String CATEGORY_CATEGORY = "category";
    public static final String defaultModNameFormatFriendly = "blue italic";
    public static final int smallestNumColumns = 4;
    public static final int largestNumColumns = 100;
    public static final int minRecipeGuiHeight = 175;
    public static final int maxRecipeGuiHeight = 5000;
    @Nullable
    private static LocalizedConfiguration config;
    @Nullable
    private static Configuration worldConfig;
    @Nullable
    private static LocalizedConfiguration itemBlacklistConfig;
    @Nullable
    private static LocalizedConfiguration searchColorsConfig;
    @Nullable
    private static File bookmarkFile;
    @Nullable
    private static File favoriteFile;
    private static final ConfigValues defaultValues;
    private static final ConfigValues values;
    @Nullable
    private static String modNameFormatOverride;
    private static final Set<String> itemBlacklist;
    private static final String[] defaultItemBlacklist;
    public static boolean needToRebuildSearchTree;

    private Config() {
    }

    public static boolean isOverlayEnabled() {
        return Config.values.overlayEnabled || KeyBindings.toggleOverlay.func_151463_i() == 0;
    }

    public static void toggleOverlayEnabled() {
        boolean bl = Config.values.overlayEnabled = !Config.values.overlayEnabled;
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "overlayEnabled", Config.defaultValues.overlayEnabled);
            property.set(Config.values.overlayEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new OverlayToggleEvent(Config.values.overlayEnabled));
    }

    public static boolean isBookmarkOverlayEnabled() {
        return Config.isOverlayEnabled() && Config.values.bookmarkOverlayEnabled;
    }

    public static void toggleBookmarkEnabled() {
        boolean bl = Config.values.bookmarkOverlayEnabled = !Config.values.bookmarkOverlayEnabled;
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "bookmarkOverlayEnabled", Config.defaultValues.bookmarkOverlayEnabled);
            property.set(Config.values.bookmarkOverlayEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new BookmarkOverlayToggleEvent(Config.values.bookmarkOverlayEnabled));
    }

    public static boolean isCheatItemsEnabled() {
        return Config.values.cheatItemsEnabled;
    }

    public static void toggleCheatItemsEnabled() {
        Config.setCheatItemsEnabled(!Config.values.cheatItemsEnabled);
    }

    public static void setCheatItemsEnabled(boolean value) {
        if (Config.values.cheatItemsEnabled != value) {
            Config.values.cheatItemsEnabled = value;
            if (worldConfig != null) {
                NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
                String worldCategory = ServerInfo.getWorldUid(networkManager);
                Property property = worldConfig.get(worldCategory, "cheatItemsEnabled", Config.defaultValues.cheatItemsEnabled);
                property.set(Config.values.cheatItemsEnabled);
                if (worldConfig.hasChanged()) {
                    worldConfig.save();
                }
            }
            if (Config.values.cheatItemsEnabled && ServerInfo.isJeiOnServer()) {
                JustEnoughItems.getProxy().sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    public static boolean isEditModeEnabled() {
        return Config.values.editModeEnabled;
    }

    public static void toggleEditModeEnabled() {
        boolean bl = Config.values.editModeEnabled = !Config.values.editModeEnabled;
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "editEnabled", Config.defaultValues.editModeEnabled);
            property.set(Config.values.editModeEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new EditModeToggleEvent(Config.values.editModeEnabled));
    }

    public static boolean areRecipeBookmarksEnabled() {
        return Config.values.recipeBookmarksEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return Config.values.debugModeEnabled;
    }

    public static boolean isDeleteItemsInCheatModeActive() {
        return Config.values.cheatItemsEnabled && ServerInfo.isJeiOnServer();
    }

    public static boolean isCenterSearchBarEnabled() {
        return Config.values.centerSearchBarEnabled;
    }

    public static boolean isOptimizeMemoryUsage() {
        return true;
    }

    public static boolean isSearchTreeBuildingAsync() {
        return Config.values.asyncSearchTreeBuilding;
    }

    public static boolean isAddingBookmarksToFront() {
        return Config.values.addBookmarksToFront;
    }

    public static boolean isUltraLowMemoryMode() {
        return Config.values.ultraLowMemoryUsage;
    }

    public static GiveMode getGiveMode() {
        return Config.values.giveMode;
    }

    public static String getModNameFormat() {
        String override = modNameFormatOverride;
        if (override != null) {
            return override;
        }
        return Config.values.modNameFormat;
    }

    public static boolean isModNameFormatOverrideActive() {
        return modNameFormatOverride != null;
    }

    public static void checkForModNameFormatOverride() {
        IModIdHelper modIdHelper = ForgeModIdHelper.getInstance();
        modNameFormatOverride = modIdHelper.getModNameTooltipFormatting();
        if (config != null) {
            Config.updateModNameFormat(config);
        }
    }

    public static int getMaxColumns() {
        return Config.values.maxColumns;
    }

    public static int getMaxRecipeGuiHeight() {
        return Config.values.maxRecipeGuiHeight;
    }

    public static SearchMode getModNameSearchMode() {
        return Config.values.modNameSearchMode;
    }

    public static SearchMode getTooltipSearchMode() {
        return Config.values.tooltipSearchMode;
    }

    public static SearchMode getOreDictSearchMode() {
        return Config.values.oreDictSearchMode;
    }

    public static SearchMode getCreativeTabSearchMode() {
        return Config.values.creativeTabSearchMode;
    }

    public static SearchMode getColorSearchMode() {
        return Config.values.colorSearchMode;
    }

    public static SearchMode getResourceIdSearchMode() {
        return Config.values.resourceIdSearchMode;
    }

    public static boolean getSearchAdvancedTooltips() {
        return Config.values.searchAdvancedTooltips;
    }

    public static boolean getSearchStrippedDiacritics() {
        return Config.values.searchStrippedDiacritics;
    }

    public static boolean doesSearchTreeNeedReload() {
        if (config == null) {
            return false;
        }
        boolean needToRebuildSearchTree = Config.needToRebuildSearchTree;
        Config.needToRebuildSearchTree = false;
        return needToRebuildSearchTree;
    }

    public static boolean isAutocraftingEnabled() {
        return Config.values.autocraftingEnabled && Config.values.bookmarkOverlayEnabled;
    }

    public static boolean setFilterText(String filterText) {
        if (Config.values.filterText.equals(filterText)) {
            return false;
        }
        Config.values.filterText = filterText;
        return true;
    }

    public static String getFilterText() {
        return Config.values.filterText;
    }

    public static void saveFilterText() {
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "filterText", Config.defaultValues.filterText);
            property.set(Config.values.filterText);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
    }

    public static ItemStack getDefaultFluidContainerItem() {
        return Config.values.defaultFluidContainerItem.func_77946_l();
    }

    public static boolean bufferIngredientRenders() {
        return Config.values.bufferIngredientRenders;
    }

    public static boolean mouseClickToSeeRecipe() {
        return Config.values.mouseClickToSeeRecipes;
    }

    public static boolean getTooltipShowRecipeBy() {
        return Config.values.tooltipShowRecipeBy;
    }

    public static boolean getShowHiddenIngredientsInCreative() {
        return Config.values.showHiddenIngredientsInCreative;
    }

    public static boolean skipShowingProgressBar() {
        return Config.values.skipShowingProgressBar;
    }

    public static boolean hideBottomRightCornerConfigButton() {
        return Config.values.hideBottomRightCornerConfigButton;
    }

    public static boolean hideBottomLeftCornerBookmarkButton() {
        return Config.values.hideBottomLeftCornerBookmarkButton;
    }

    public static int getRecipeBookmarkGroupColor() {
        return Config.values.recipeBookmarkGroupColor;
    }

    public static List<String> categoryUidOrder() {
        return Config.values.categoryUidOrder;
    }

    @Nullable
    public static LocalizedConfiguration getConfig() {
        return config;
    }

    @Nullable
    public static Configuration getWorldConfig() {
        return worldConfig;
    }

    @Nullable
    public static File getBookmarkFile() {
        return bookmarkFile;
    }

    @Nullable
    public static File getFavoriteFile() {
        return favoriteFile;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        File jeiConfigurationDir = new File(event.getModConfigurationDirectory(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    Log.get().error("Could not create config directory {}", (Object)jeiConfigurationDir);
                    return;
                }
            }
            catch (SecurityException e) {
                Log.get().error("Could not create config directory {}", (Object)jeiConfigurationDir, (Object)e);
                return;
            }
        }
        bookmarkFile = new File("./", "hei_bookmarks.ini");
        File oldBookmarkFile = new File(jeiConfigurationDir, "bookmarks.ini");
        if (oldBookmarkFile.exists() && !bookmarkFile.exists()) {
            try {
                FileUtils.moveFile((File)oldBookmarkFile, (File)bookmarkFile);
            }
            catch (IOException e) {
                Log.get().error("Could not move the old bookmark file from {} to {}", (Object)jeiConfigurationDir, (Object)"./", (Object)e);
                return;
            }
        }
        favoriteFile = new File("./", "hei_favorites.ini");
        File configFile = new File(jeiConfigurationDir, "jei.cfg");
        File itemBlacklistConfigFile = new File(jeiConfigurationDir, "itemBlacklist.cfg");
        File searchColorsConfigFile = new File(jeiConfigurationDir, "searchColors.cfg");
        File worldConfigFile = new File(jeiConfigurationDir, "worldSettings.cfg");
        worldConfig = new Configuration(worldConfigFile, "0.1.0");
        config = new LocalizedConfiguration(configKeyPrefix, configFile, "0.4.0");
        itemBlacklistConfig = new LocalizedConfiguration(configKeyPrefix, itemBlacklistConfigFile, "0.1.0");
        searchColorsConfig = new LocalizedConfiguration(configKeyPrefix, searchColorsConfigFile, "0.1.0");
        Config.syncConfig();
        Config.syncItemBlacklistConfig();
        Config.syncSearchColorsConfig();
    }

    public static boolean syncAllConfig() {
        NetworkManager networkManager;
        boolean needsReload = false;
        if (Config.syncConfig()) {
            needsReload = true;
        }
        if (Config.syncItemBlacklistConfig()) {
            needsReload = true;
        }
        if (Config.syncWorldConfig(networkManager = FMLClientHandler.instance().getClientToServerNetworkManager())) {
            needsReload = true;
        }
        if (Config.syncSearchColorsConfig()) {
            needsReload = true;
        }
        return needsReload;
    }

    private static boolean syncConfig() {
        ConfigCategory interfaceCategory;
        ConfigCategory addonsCategory;
        if (config == null) {
            return false;
        }
        boolean needsReload = false;
        config.addCategory(CATEGORY_SEARCH);
        config.addCategory(CATEGORY_ADVANCED);
        config.addCategory(CATEGORY_MISC);
        ConfigCategory modeCategory = config.getCategory("mode");
        if (modeCategory != null) {
            config.removeCategory(modeCategory);
        }
        if ((addonsCategory = config.getCategory("addons")) != null) {
            config.removeCategory(addonsCategory);
        }
        if ((interfaceCategory = config.getCategory("interface")) != null) {
            config.removeCategory(interfaceCategory);
        }
        ConfigCategory searchCategory = config.getCategory(CATEGORY_SEARCH);
        searchCategory.remove((Object)"atPrefixRequiredForModName");
        searchCategory.remove((Object)"prefixRequiredForTooltipSearch");
        searchCategory.remove((Object)"prefixRequiredForOreDictSearch");
        searchCategory.remove((Object)"prefixRequiredForCreativeTabSearch");
        searchCategory.remove((Object)"prefixRequiredForColorSearch");
        Enum[] searchModes = SearchMode.values();
        String loadedConfigVersion = config.getLoadedConfigVersion();
        if (loadedConfigVersion != null && Config.versionCompare(loadedConfigVersion, "0.3.0") < 0) {
            config.setEnum("creativeTabSearchMode", CATEGORY_SEARCH, Config.defaultValues.creativeTabSearchMode, searchModes);
            config.setEnum("oreDictSearchMode", CATEGORY_SEARCH, Config.defaultValues.oreDictSearchMode, searchModes);
        }
        Config.values.modNameSearchMode = (SearchMode)config.getEnum("modNameSearchMode", CATEGORY_SEARCH, Config.defaultValues.modNameSearchMode, searchModes);
        Config.values.tooltipSearchMode = (SearchMode)config.getEnum("tooltipSearchMode", CATEGORY_SEARCH, Config.defaultValues.tooltipSearchMode, searchModes);
        Config.values.oreDictSearchMode = (SearchMode)config.getEnum("oreDictSearchMode", CATEGORY_SEARCH, Config.defaultValues.oreDictSearchMode, searchModes);
        Config.values.creativeTabSearchMode = (SearchMode)config.getEnum("creativeTabSearchMode", CATEGORY_SEARCH, Config.defaultValues.creativeTabSearchMode, searchModes);
        Config.values.colorSearchMode = (SearchMode)config.getEnum("colorSearchMode", CATEGORY_SEARCH, Config.defaultValues.colorSearchMode, searchModes);
        Config.values.resourceIdSearchMode = (SearchMode)config.getEnum("resourceIdSearchMode", CATEGORY_SEARCH, Config.defaultValues.resourceIdSearchMode, searchModes);
        Config.values.searchAdvancedTooltips = config.getBoolean(CATEGORY_SEARCH, "searchAdvancedTooltips", Config.defaultValues.searchAdvancedTooltips);
        Config.values.searchStrippedDiacritics = config.getBoolean(CATEGORY_SEARCH, "searchStrippedDiacritics", Config.defaultValues.searchStrippedDiacritics);
        if (searchCategory.hasChanged()) {
            needsReload = true;
            needToRebuildSearchTree = true;
        }
        ConfigCategory categoryAdvanced = config.getCategory(CATEGORY_ADVANCED);
        categoryAdvanced.remove((Object)"nbtKeyIgnoreList");
        categoryAdvanced.remove((Object)"deleteItemsInCheatModeEnabled");
        categoryAdvanced.remove((Object)"hideLaggyModelsEnabled");
        categoryAdvanced.remove((Object)"hideMissingModelsEnabled");
        categoryAdvanced.remove((Object)"debugItemEnabled");
        categoryAdvanced.remove((Object)"colorSearchEnabled");
        categoryAdvanced.remove((Object)"maxSubtypes");
        Config.values.centerSearchBarEnabled = config.getBoolean(CATEGORY_ADVANCED, "centerSearchBarEnabled", Config.defaultValues.centerSearchBarEnabled);
        Config.values.ultraLowMemoryUsage = config.getBoolean(CATEGORY_ADVANCED, "ultraLowMemoryUsage", Config.defaultValues.ultraLowMemoryUsage);
        Config.values.asyncSearchTreeBuilding = config.getBoolean(CATEGORY_ADVANCED, "asyncSearchTreeBuilding", Config.defaultValues.asyncSearchTreeBuilding);
        Config.values.addBookmarksToFront = config.getBoolean(CATEGORY_ADVANCED, "addBookmarksToFront", Config.defaultValues.addBookmarksToFront);
        Config.values.giveMode = (GiveMode)config.getEnum("giveMode", CATEGORY_ADVANCED, Config.defaultValues.giveMode, GiveMode.values());
        Config.values.maxColumns = config.getInt("maxColumns", CATEGORY_ADVANCED, Config.defaultValues.maxColumns, 4, 100);
        Config.values.maxRecipeGuiHeight = config.getInt("maxRecipeGuiHeight", CATEGORY_ADVANCED, Config.defaultValues.maxRecipeGuiHeight, 175, 5000);
        Config.values.recipeBookmarkGroupColor = config.getInt("recipeBookmarkGroupColor", CATEGORY_ADVANCED, Config.defaultValues.recipeBookmarkGroupColor, Integer.MIN_VALUE, Integer.MAX_VALUE);
        Config.updateModNameFormat(config);
        Config.values.bufferIngredientRenders = config.getBoolean(CATEGORY_RENDERING, "bufferIngredientRenders", Config.defaultValues.bufferIngredientRenders);
        Config.values.mouseClickToSeeRecipes = config.getBoolean(CATEGORY_MISC, "mouseClickToSeeRecipes", Config.defaultValues.mouseClickToSeeRecipes);
        Config.values.tooltipShowRecipeBy = config.getBoolean(CATEGORY_MISC, "tooltipShowRecipeBy", Config.defaultValues.tooltipShowRecipeBy);
        Config.values.showHiddenIngredientsInCreative = config.getBoolean(CATEGORY_MISC, "showHiddenIngredientsInCreative", Config.defaultValues.showHiddenIngredientsInCreative);
        Config.values.skipShowingProgressBar = config.getBoolean(CATEGORY_MISC, "skipShowingProgressBar", Config.defaultValues.skipShowingProgressBar);
        Config.values.hideBottomRightCornerConfigButton = config.getBoolean(CATEGORY_MISC, "hideBottomRightCornerConfigButton", Config.defaultValues.hideBottomRightCornerConfigButton);
        Config.values.hideBottomLeftCornerBookmarkButton = config.getBoolean(CATEGORY_MISC, "hideBottomLeftCornerBookmarkButton", Config.defaultValues.hideBottomLeftCornerBookmarkButton);
        Property property = config.get(CATEGORY_ADVANCED, "debugModeEnabled", Config.defaultValues.debugModeEnabled);
        property.setShowInGui(false);
        Config.values.debugModeEnabled = property.getBoolean();
        if (!needToRebuildSearchTree) {
            needToRebuildSearchTree = categoryAdvanced.get("ultraLowMemoryUsage").hasChanged();
        }
        String[] categoryUidOrder = config.getStringList("categoryUidOrder", CATEGORY_CATEGORY, Config.defaultValues.categoryUidOrder.toArray(new String[0]));
        Config.values.categoryUidOrder = Arrays.asList(categoryUidOrder);
        boolean configChanged = config.hasChanged();
        if (configChanged) {
            config.save();
        }
        return needsReload;
    }

    private static void updateModNameFormat(LocalizedConfiguration config) {
        EnumSet<TextFormatting> validFormatting = EnumSet.allOf(TextFormatting.class);
        validFormatting.remove(TextFormatting.RESET);
        String[] validValues = new String[validFormatting.size()];
        int i = 0;
        for (TextFormatting formatting : validFormatting) {
            validValues[i] = formatting.func_96297_d().toLowerCase(Locale.ENGLISH);
            ++i;
        }
        Property property = config.getString("modNameFormat", CATEGORY_ADVANCED, defaultModNameFormatFriendly, validValues);
        boolean showInGui = !Config.isModNameFormatOverrideActive();
        property.setShowInGui(showInGui);
        String modNameFormatFriendly = property.getString();
        Config.values.modNameFormat = Config.parseFriendlyModNameFormat(modNameFormatFriendly);
    }

    public static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format.append(valueByName.toString());
                continue;
            }
            Log.get().error("Invalid format: {}", (Object)string);
        }
        return format.toString();
    }

    private static boolean syncItemBlacklistConfig() {
        if (itemBlacklistConfig == null) {
            return false;
        }
        itemBlacklistConfig.addCategory(CATEGORY_ADVANCED);
        String[] itemBlacklistArray = itemBlacklistConfig.getStringList("itemBlacklist", CATEGORY_ADVANCED, defaultItemBlacklist);
        itemBlacklist.clear();
        Collections.addAll(itemBlacklist, itemBlacklistArray);
        boolean configChanged = itemBlacklistConfig.hasChanged();
        if (configChanged) {
            itemBlacklistConfig.save();
        }
        return configChanged;
    }

    public static boolean syncWorldConfig(@Nullable NetworkManager networkManager) {
        if (worldConfig == null) {
            return false;
        }
        String worldCategory = ServerInfo.getWorldUid(networkManager);
        Property property = worldConfig.get(worldCategory, "overlayEnabled", Config.defaultValues.overlayEnabled);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        Config.values.overlayEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "cheatItemsEnabled", Config.defaultValues.cheatItemsEnabled);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        Config.values.cheatItemsEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "editEnabled", Config.defaultValues.editModeEnabled);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        Config.values.editModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            MinecraftForge.EVENT_BUS.post((Event)new EditModeToggleEvent(Config.values.editModeEnabled));
        }
        property = worldConfig.get(worldCategory, "bookmarkOverlayEnabled", Config.defaultValues.bookmarkOverlayEnabled);
        property.setLanguageKey("config.jei.interface.bookmarkOverlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.bookmarkOverlayEnabled.comment"));
        property.setShowInGui(false);
        Config.values.bookmarkOverlayEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "autocraftingEnabled", Config.defaultValues.recipeBookmarksEnabled);
        property.setLanguageKey("config.jei.interface.autocraftingEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.autocraftingEnabled.comment"));
        Config.values.autocraftingEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "recipeBookmarksEnabled", Config.defaultValues.autocraftingEnabled);
        property.setLanguageKey("config.jei.interface.recipeBookmarksEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.autocraftingEnabled.comment"));
        Config.values.autocraftingEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "filterText", Config.defaultValues.filterText);
        property.setShowInGui(false);
        Config.values.filterText = property.getString();
        property = worldConfig.get(worldCategory, "defaultFluidContainerItem", "");
        property.setLanguageKey("config.jei.interface.defaultFluidContainerItem");
        property.setComment(Translator.translateToLocal("config.jei.interface.defaultFluidContainerItem.comment"));
        String defaultFluidContainerItem = property.getString();
        if (!defaultFluidContainerItem.isEmpty()) {
            String[] defaultFluidContainerItemFormatted = defaultFluidContainerItem.split("@");
            Item item = Item.func_111206_d((String)(defaultFluidContainerItem = defaultFluidContainerItemFormatted[0]));
            if (item != null) {
                IFluidHandlerItem container;
                ItemStack stack = new ItemStack(Items.field_151133_ar);
                if (defaultFluidContainerItemFormatted.length > 1) {
                    try {
                        int meta = Integer.decode(defaultFluidContainerItemFormatted[1]);
                        stack = new ItemStack(item, 1, meta);
                    }
                    catch (NumberFormatException e) {
                        new IllegalArgumentException(String.format("%s is not a valid meta", defaultFluidContainerItemFormatted[1])).printStackTrace();
                    }
                } else {
                    stack = new ItemStack(item);
                }
                if ((container = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) {
                    new IllegalArgumentException(String.format("%s is not a fluid container", defaultFluidContainerItem)).printStackTrace();
                    Config.values.defaultFluidContainerItem = new ItemStack(Items.field_151133_ar);
                } else {
                    Config.values.defaultFluidContainerItem = stack;
                }
            } else {
                new IllegalArgumentException(String.format("%s isn't a valid item ID", defaultFluidContainerItem)).printStackTrace();
                Config.values.defaultFluidContainerItem = new ItemStack(Items.field_151133_ar);
            }
        } else {
            Config.values.defaultFluidContainerItem = new ItemStack(Items.field_151133_ar);
        }
        boolean configChanged = worldConfig.hasChanged();
        if (configChanged) {
            worldConfig.save();
        }
        return false;
    }

    private static boolean syncSearchColorsConfig() {
        if (searchColorsConfig == null) {
            return false;
        }
        searchColorsConfig.addCategory(CATEGORY_SEARCH_COLORS);
        String[] searchColorDefaults = ColorGetter.getColorDefaults();
        String[] searchColors = searchColorsConfig.getStringList(CATEGORY_SEARCH_COLORS, CATEGORY_SEARCH_COLORS, searchColorDefaults);
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                Log.get().error("Invalid format for searchColor entry: {}", (Object)entry);
                continue;
            }
            try {
                String name = values[0];
                int colorValue = Integer.decode("0x" + values[1]);
                Color color = new Color(colorValue);
                searchColorsMapBuilder.put((Object)color, (Object)name);
            }
            catch (NumberFormatException e) {
                Log.get().error("Invalid number format for searchColor entry: {}", (Object)entry, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Color, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
        boolean configChanged = searchColorsConfig.hasChanged();
        if (configChanged) {
            searchColorsConfig.save();
        }
        return configChanged;
    }

    private static void updateBlacklist() {
        if (itemBlacklistConfig == null) {
            return;
        }
        Property property = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
        String[] currentBlacklist = itemBlacklist.toArray(new String[0]);
        property.set(currentBlacklist);
        boolean changed = itemBlacklistConfig.hasChanged();
        if (changed) {
            itemBlacklistConfig.save();
        }
    }

    public static <V> void addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, IIngredientRegistry ingredientRegistry, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        IIngredientType<V> ingredientType = ingredientRegistry.getIngredientType(ingredient);
        IIngredientListElement<V> element = IngredientListElementFactory.createUnorderedElement(ingredientRegistry, ingredientType, ingredient, ForgeModIdHelper.getInstance());
        Preconditions.checkNotNull(element, (Object)"Failed to create element for blacklist");
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String uid = Config.getIngredientUid(ingredient, IngredientBlacklistType.ITEM, ingredientHelper);
            List<IIngredientListElement<V>> elementsToBeBlacklisted = ingredientFilter.getMatches(element, input -> Config.getIngredientUid(input, IngredientBlacklistType.WILDCARD));
            if (Config.areAllBlacklisted(elementsToBeBlacklisted, uid, IngredientBlacklistType.ITEM)) {
                if (Config.addIngredientToConfigBlacklist(ingredientFilter, element, ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper)) {
                    Config.updateBlacklist();
                }
                return;
            }
        }
        if (Config.addIngredientToConfigBlacklist(ingredientFilter, element, ingredient, blacklistType, ingredientHelper)) {
            Config.updateBlacklist();
        }
    }

    private static <V> boolean addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, IIngredientListElement<V> element, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElement<V>> elementsToBeBlacklisted = ingredientFilter.getMatches(element, input -> Config.getIngredientUid(input, blacklistType));
            for (IIngredientListElement<V> elementToBeBlacklisted : elementsToBeBlacklisted) {
                String uid = Config.getIngredientUid(elementToBeBlacklisted, IngredientBlacklistType.ITEM);
                updated |= itemBlacklist.remove(uid);
            }
        }
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return updated |= itemBlacklist.add(uid);
    }

    private static <V> boolean areAllBlacklisted(List<IIngredientListElement<V>> elements, String newUid, IngredientBlacklistType blacklistType) {
        for (IIngredientListElement<V> element : elements) {
            String uid = Config.getIngredientUid(element, blacklistType);
            if (uid.equals(newUid) || itemBlacklist.contains(uid)) continue;
            return false;
        }
        return true;
    }

    public static <V> void removeIngredientFromConfigBlacklist(IngredientFilter ingredientFilter, IIngredientRegistry ingredientRegistry, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid;
        List<IIngredientListElement<V>> modMatches;
        IIngredientType<V> ingredientType = ingredientRegistry.getIngredientType(ingredient);
        IIngredientListElement<V> element = IngredientListElementFactory.createUnorderedElement(ingredientRegistry, ingredientType, ingredient, ForgeModIdHelper.getInstance());
        Preconditions.checkNotNull(element, (Object)"Failed to create element for blacklist");
        boolean updated = false;
        String modUid = Config.getIngredientUid(ingredient, IngredientBlacklistType.MOD_ID, ingredientHelper);
        if (itemBlacklist.contains(modUid)) {
            updated = true;
            itemBlacklist.remove(modUid);
            modMatches = ingredientFilter.getMatches(element, input -> Config.getIngredientUid(input, IngredientBlacklistType.MOD_ID));
            for (IIngredientListElement<V> modMatch : modMatches) {
                Config.addIngredientToConfigBlacklist(ingredientFilter, modMatch, modMatch.getIngredient(), IngredientBlacklistType.ITEM, ingredientHelper);
            }
        }
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String wildUid = Config.getIngredientUid(ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
            if (itemBlacklist.contains(wildUid)) {
                updated = true;
                itemBlacklist.remove(wildUid);
                modMatches = ingredientFilter.getMatches(element, input -> Config.getIngredientUid(input, IngredientBlacklistType.WILDCARD));
                for (IIngredientListElement<V> modMatch : modMatches) {
                    Config.addIngredientToConfigBlacklist(ingredientFilter, modMatch, modMatch.getIngredient(), IngredientBlacklistType.ITEM, ingredientHelper);
                }
            }
        } else if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElement<V>> modMatches2 = ingredientFilter.getMatches(element, input -> Config.getIngredientUid(input, IngredientBlacklistType.WILDCARD));
            for (IIngredientListElement<V> modMatch : modMatches2) {
                String uid2 = Config.getIngredientUid(modMatch, IngredientBlacklistType.ITEM);
                updated |= itemBlacklist.remove(uid2);
            }
        }
        if (updated |= itemBlacklist.remove(uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper))) {
            Config.updateBlacklist();
        }
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!Config.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return itemBlacklist.contains(uid);
    }

    private static <V> String getIngredientUid(@Nullable IIngredientListElement<V> element, IngredientBlacklistType blacklistType) {
        if (element == null) {
            return "";
        }
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        return Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
            case MOD_ID: {
                return ingredientHelper.getModId(ingredient);
            }
        }
        throw new IllegalStateException("Unknown blacklist type: " + (Object)((Object)blacklistType));
    }

    private static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    static {
        defaultValues = new ConfigValues();
        values = new ConfigValues();
        itemBlacklist = new HashSet<String>();
        defaultItemBlacklist = new String[0];
    }

    public static enum SearchMode {
        ENABLED,
        REQUIRE_PREFIX,
        DISABLED;

    }
}

