/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.autocrafting.IngredientUtil;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.bookmarks.BookmarkGroup;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class BookmarkItem<I> {
    public static final IIngredientType<BookmarkItem> TYPE = () -> BookmarkItem.class;
    public I ingredient;
    public long amount = 0L;
    @Nullable
    protected BookmarkGroup group;
    protected static final String MARKER_OTHER = "O:";
    protected static final String MARKER_STACK = "T:";
    private static final char MARKER_NORMAL = 'B';
    protected static final char MARKER_RECIPE = 'R';

    public BookmarkItem(I ingredient) {
        this.ingredient = IngredientUtil.normalizeCopy(ingredient);
    }

    public BookmarkItem<I> copy() {
        return new BookmarkItem<I>(this.ingredient);
    }

    @Nullable
    public IIngredientListElement<I> getSavedElement() {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<I> ingredientType = ingredientRegistry.getIngredientType(this.ingredient);
        return IngredientListElementFactory.createUnorderedElement(ingredientRegistry, ingredientType, this.ingredient, ForgeModIdHelper.getInstance());
    }

    public int getGroupIndex() {
        return this.getGroup() == null ? 0 : this.getGroup().id;
    }

    public void changeAmount(long delta) {
        this.amount = (long)Math.round(this.amount / delta) * delta;
        this.amount += delta;
        this.amount = Math.max(0L, this.amount);
    }

    public boolean startsNewRow() {
        return false;
    }

    public long getDisplayAmount() {
        return this.amount;
    }

    public boolean deserialize(NBTTagCompound tag) {
        this.amount = tag.func_74763_f("amount");
        return true;
    }

    @Nullable
    public String serialize() {
        NBTTagCompound tag = this.getNBTOfIngredient(this.ingredient);
        tag.func_74772_a("amount", this.amount);
        if (this.ingredient instanceof ItemStack) {
            return "BT:" + tag;
        }
        return "BO:" + tag;
    }

    protected NBTTagCompound getNBTOfIngredient(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            return ((ItemStack)ingredient).func_77955_b(new NBTTagCompound());
        }
        IIngredientListElement<I> listElement = this.getSavedElement();
        if (listElement == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uid", Internal.getIngredientRegistry().getUniqueId(listElement.getIngredient()));
        return tag;
    }

    @Nullable
    public static BookmarkItem<?> deserialize(String ingredientJsonString, Collection<IIngredientType> otherIngredientTypes) {
        BookmarkItem<Object> item;
        Object ingredient = BookmarkItem.parseIngredient(ingredientJsonString.substring(1), otherIngredientTypes);
        if (ingredient == null) {
            ingredient = BookmarkItem.parseIngredientOld(ingredientJsonString, otherIngredientTypes);
            if (ingredient == null) {
                return null;
            }
            BookmarkItem<Object> item2 = new BookmarkItem<Object>(ingredient);
            return item2;
        }
        switch (ingredientJsonString.charAt(0)) {
            case 'B': {
                item = new BookmarkItem<Object>(ingredient);
                break;
            }
            case 'R': {
                item = new RecipeBookmarkItem<Object>(ingredient);
                break;
            }
            default: {
                return null;
            }
        }
        if (item.deserialize(BookmarkItem.getNBT(ingredientJsonString))) {
            return item;
        }
        return null;
    }

    @Nullable
    protected static Object parseIngredient(String ingredientJsonString, Collection<IIngredientType> otherIngredientTypes) {
        NBTTagCompound parsed;
        if (ingredientJsonString.startsWith(MARKER_STACK)) {
            NBTTagCompound parsed2 = BookmarkItem.getNBT(ingredientJsonString);
            if (parsed2 != null) {
                ItemStack itemStack = new ItemStack(parsed2);
                if (!itemStack.func_190926_b()) {
                    IngredientUtil.normalize(itemStack);
                    return itemStack;
                }
                Log.get().warn("Failed to load bookmarked ItemStack, the item no longer exists:\n{}", (Object)parsed2);
            }
        } else if (ingredientJsonString.startsWith(MARKER_OTHER) && (parsed = BookmarkItem.getNBT(ingredientJsonString)) != null) {
            Object ingredient = BookmarkItem.getUnknownIngredientByUid(otherIngredientTypes, parsed.func_74779_i("uid"));
            if (ingredient != null) {
                IngredientUtil.normalize(ingredient);
                return ingredient;
            }
            Log.get().warn("Failed to load bookmarked unknown ingredient, the ingredient no longer exists:\n{}", (Object)parsed);
        }
        return null;
    }

    @Nullable
    protected static Object parseIngredientOld(String ingredientJsonString, Collection<IIngredientType> otherIngredientTypes) {
        if (ingredientJsonString.startsWith(MARKER_STACK)) {
            return BookmarkItem.parseIngredient(ingredientJsonString, otherIngredientTypes);
        }
        if (ingredientJsonString.startsWith(MARKER_OTHER)) {
            Object ingredient = BookmarkItem.getUnknownIngredientByUid(otherIngredientTypes, ingredientJsonString.substring(2));
            if (ingredient != null) {
                IngredientUtil.normalize(ingredient);
                return ingredient;
            }
            Log.get().warn("Failed to load bookmarked unknown ingredient, the ingredient no longer exists:\n{}", (Object)ingredientJsonString.substring(2));
        }
        return null;
    }

    @Nullable
    private static Object getUnknownIngredientByUid(Collection<IIngredientType> ingredientTypes, String uid) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        for (IIngredientType ingredientType : ingredientTypes) {
            Object ingredient = ingredientRegistry.getIngredientByUid(ingredientType, uid);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    @Nullable
    private static NBTTagCompound getNBT(String ingredientString) {
        int colonAfterMarker = ingredientString.indexOf(58);
        if (colonAfterMarker < 0) {
            Log.get().error("Bookmark ingredient parsing error: missing separator ':' in bookmark string:\n{}", (Object)ingredientString);
            return null;
        }
        try {
            return JsonToNBT.func_180713_a((String)ingredientString.substring(colonAfterMarker + 1));
        }
        catch (NBTException e) {
            Log.get().error("Failed to parse bookmarked ingredient from JSON:\n{}", (Object)ingredientString, (Object)e);
            return null;
        }
    }

    public <O> void setIngredient(O ingredient) {
        if (this.ingredient.getClass().isAssignableFrom(ingredient.getClass())) {
            this.ingredient = ingredient;
        }
    }

    public void setGroup(@Nullable BookmarkGroup group) {
        this.group = group;
    }

    @Nullable
    public BookmarkGroup getGroup() {
        return this.group;
    }
}

