/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;

public class BookmarkGroup {
    protected final List<BookmarkItem<?>> items = new ArrayList();
    private final List<IIngredientListElement<?>> ingredientListElements = new LinkedList();
    public int id;

    public BookmarkGroup(int id) {
        this.id = id;
    }

    public List<BookmarkItem<?>> getItems() {
        return this.items;
    }

    public List<IIngredientListElement<?>> getIngredientListElements() {
        return this.ingredientListElements;
    }

    public boolean addItem(BookmarkItem<?> item) {
        if (this.canAddItem(item)) {
            this.addItemInternal(item);
            return true;
        }
        return false;
    }

    public List<BookmarkItem<?>> getItemsInternal() {
        return this.items;
    }

    public void addItemInternal(BookmarkItem<?> item) {
        this.items.add(item);
        this.ingredientListElements.add(this.getIngredientListElement(item));
        item.setGroup(this);
    }

    public boolean canAddItem(BookmarkItem<?> item) {
        return !(item instanceof RecipeBookmarkItem);
    }

    public void removeItem(BookmarkItem<?> item) {
        int index = this.items.indexOf(item);
        if (index != -1) {
            this.items.remove(index);
            this.ingredientListElements.remove(index);
        }
    }

    public boolean addItem(BookmarkItem<?> item, boolean toFront) {
        IIngredientListElement<BookmarkItem<?>> element = this.getIngredientListElement(item);
        if (element == null) {
            return false;
        }
        if (toFront) {
            this.items.add(0, item);
            this.ingredientListElements.add(0, element);
        } else {
            this.items.add(item);
            this.ingredientListElements.add(element);
        }
        item.setGroup(this);
        return true;
    }

    @Nullable
    protected <T> IIngredientListElement<T> getIngredientListElement(T ingredient) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<T> ingredientType = ingredientRegistry.getIngredientType(ingredient);
        return IngredientListElementFactory.createUnorderedElement(ingredientRegistry, ingredientType, ingredient, ForgeModIdHelper.getInstance());
    }

    public boolean acceptsChanges() {
        return true;
    }

    public int getColor() {
        return Integer.MAX_VALUE;
    }

    public void finishLoading() {
    }
}

